---
generated_at: 2026-02-03 10:10:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：3-Indices Report

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 全項目に根拠あり。重点レビュー項目なし。

## 2) 参照した情報（Evidence一覧）

- E-01: `server/src/main/java/org/opensearch/rest/action/cat/RestIndicesAction.java` 行100-1270
- E-02: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 行4
- E-03: `server/src/test/java/org/opensearch/rest/action/cat/RestIndicesActionTests.java`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | エンドポイントは GET /_cat/indices と GET /_cat/indices/{index} | E-01 行117 | ○ |
| C-02 | AbstractListAction を継承 | E-01 行100 | ○ |
| C-03 | allowSystemIndexAccessByDefault が true | E-01 行126-128 | ○ |
| C-04 | 4つの内部APIを使用（GetSettings, ClusterState, ClusterHealth, IndicesStats） | E-01 行166-253 | ○ |
| C-05 | health パラメータでフィルタリング | E-01 行901,930-943 | ○ |
| C-06 | ResponseLimitBreachedException の発生条件 | E-01 行258-265 | ○ |
| C-07 | master_timeout と cluster_manager_timeout の重複エラー | E-01 行148-153 | ○ |
| C-08 | デフォルト表示カラム10個 | E-01 行418-431 | ○ |
| C-09 | GroupedActionListener で並列実行（size=4） | E-01 行346 | ○ |
| C-10 | isActionPaginated は false | E-01 行1238-1240 | ○ |
| C-11 | クローズインデックスは空の CommonStats | E-01 行948-951 | ○ |
| C-12 | healthが不明でstatsがある場合 "red*" | E-01 行924-926 | ○ |
| C-13 | include_unloaded_segments パラメータ | E-01 行156 | ○ |
| C-14 | STRICT_DATE_TIME_FORMATTER での日時フォーマット | E-01 行102,969 | ○ |
| C-15 | GetSettingsRequest で権限解決 | E-01 行267-291 | ○ |
| C-16 | search.throttled カラム | E-01 行876,918,1218 | ○ |
| C-17 | isRequestLimitCheckSupported が true | E-01 行137-139 | ○ |
| C-18 | 帳票一覧での定義内容 | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。全ての主張に対してソースコードからの根拠が確認された。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコードの裏付けあり

## 6) レビュアーチェックリスト（最小）
- [ ] デフォルト表示カラム10個がソースコードと一致しているか
- [ ] 4つの内部API呼び出しの順序と依存関係が正しいか
- [ ] ResponseLimit の閾値設定箇所の確認
